<?php

// Database configuration
$db_host = 'localhost';
$db_username = 'your_username';
$db_password = 'your_password';
$db_name = 'your_database';

// Establish database connection
$conn = new mysqli($db_host, $db_username, $db_password, $db_name);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Function to sanitize input data
function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Function to save inquiry data to database
function saveInquiryToDatabase($name, $email, $message) {
    global $conn;

    // Sanitize input data
    $name = sanitize_input($name);
    $email = sanitize_input($email);
    $message = sanitize_input($message);
    $date = date("Y-m-d H:i:s");

    // Prepare SQL statement
    $stmt = $conn->prepare("INSERT INTO inquiries (name, email, message, inquiry_date) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssss", $name, $email, $message, $date);

    // Execute SQL statement
    if ($stmt->execute()) {
        echo "Inquiry saved successfully.";
    } else {
        echo "Error: " . $conn->error;
    }

    // Close statement
    $stmt->close();
}

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST["name"];
    $email = $_POST["email"];
    $message = $_POST["message"];

    // Save inquiry to database
    saveInquiryToDatabase($name, $email, $message);
}

// Close database connection
$conn->close();

?>

<!DOCTYPE html>
<html>
<head>
    <title>Inquiry Form</title>
</head>
<body>

<h2>Inquiry Form</h2>
<form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
    Name: <input type="text" name="name"><br><br>
    Email: <input type="text" name="email"><br><br>
    Message: <textarea name="message" rows="5" cols="40"></textarea><br><br>
    <input type="submit" name="submit" value="Submit">
</form>

</body>
</html>
